*1964 CPS CODE using CPS Utilities;


DATA cps1964_new;
INFILE "D:\Jim\CPSdata\1964_Data\mar64.raw" DLM='"' ;

length fam18 3 ;
length faminc 8 ;
length famwgt 8 ;
length fnumper 3 ;
length hdager 3 ;
length hdsex 3 ;
length numper 3 ;
length psu 3 ;
length hdage 3 ;
length hnrlct 3 ;
length _faminc 8 ;
length povcut 4 ;
length fmifrm 3 ;
length fmise 3 ;
length fmiwag 3 ;
length region 3 ;
length povoeo 3 ;
length recnum 8 ;
length famtyp 3 ;
length famnum 3 ;
length farm 3 ;
length income 8 ;
length lineno 3 ;
length random 4 ;
length state 3 ;
length wgt 8 ;
length wkslyr 3 ;
length year 3 ;
length age 3 ;
length _income 8 ;
length _state 3 ;
length hhid $ 7 ;
length famrel 3 ;
length relhd 3 ;
length marstat 3 ;
length incuer 8 ;
length dunern 3 ;
length incfrm 8 ;
length incse 8 ;
length incwag 8 ;
length rnowrk 3 ;
length _educ 3 ;
length race 3 ;
input
	fam18 /
	faminc /
	famwgt /
	fnumper /
	hdager /
	hdsex /
	numper /
	psu /
	hdage /
	hnrlct /
	_faminc /
	povcut /
	fmifrm /
	fmise /
	fmiwag /
	region /
	povoeo /
	recnum /
	famtyp /
	famnum /
	farm /
	income /
	lineno /
	random /
	state /
	wgt /
	wkslyr /
	year /
	age /
	_income /
	_state /
	hhid /
	famrel /
	relhd /
	marstat /
	incuer /
	dunern /
	incfrm /
	incse /
	incwag /
	rnowrk /
	_educ /
	race
;

* Program code to specify labels. ;

 label recnum = "Unique record ID number" ;
 label fam18 = "Number of family members under 18" ;
 label faminc = "Total family income" ;
 label famwgt = "Family weight" ;
 label fnumper = "Number of persons in family" ;
 label hdager = "Age recode of head" ;
 label hdsex = "Gender of head" ;
 label numper = "Number of persons in household" ;
 label psu = "PSU No." ;
 label hdage = "Age of head/unrel indiv" ;
 label hnrlct = "# Nonrelatives of head of HH in HH" ;
 label _faminc = "Total family income";
 label famtyp = "Kind of family, person level" ;
 label famnum = "Family ID within household" ;
 label farm = "Farm recode" ;
 label income = "Person's total income" ;
 label lineno = "Line number" ;
 label random = "Random cluster code (sched #)" ;
 label state="State";
 label wgt = "March supplemental weight";
 label wkslyr = "Weeks worked last year";
 label year = "Year of CPS survey";
 label age = "Age of person" ;
 label _income = "Person's total income" ;
 label _state="State recoded for all years";
 label hhid = "Household ID #2  long" ;
 label famrel = "Family relationship" ;
 label relhd = "Relationship to household head" ;
 label povcut = "Poverty level cutoff dollar amount" ;
 label marstat = "Marital status" ;
 label incuer = "Income from unearned sources" ;
 label dunern = "Detailed sources of unearned income" ;
 label incfrm = "Income from farm/nonincorporated SE" ;
 label incse = "Income from nonfarm self-employ" ;
 label incwag = "Income from wage & salary" ;
 label rnowrk = "Reason did not work last year" ;
 label _educ = "Years of education" ;
 label fmifrm = "Family income-farm" ;
 label fmise = "Family income-self-employment" ;
 label fmiwag = "Family income-wages & salaries" ;
 label region = "Region of the country " ;
 label povoeo = "OEO poverty code" ;
 label race = "Race" ;

hh_id=(random*1000)+psu;

* 2 OBS HAVE FAMTYP MISSING.  THESE OBS HAVE A SAME FAMILY WGT AS PRIMARY HD, SO MAKE THEM FAMTYP=1
  THESE OBS ALSO HAVE YEAR=63 FOR SOME REASON;
IF famtyp=. THEN famtyp=1;

* FAMILY HEADS INCLUDE HEADS OF HOUSEHOLD (HDREL=1), HEADS OF SUBFAMILIES (FAMREL=0), OR 
  INDIVIDUALS (FAMTYP=4 OR 5);
IF relhd=1 OR famrel=0 OR famtyp IN(4,5) THEN head=1;
   ELSE head=0;

pers_id=_N_;

RUN;
PROC MEANS;
RUN;


PROC SORT DATA=cps1964_new;
   BY hhid ;
RUN;

* CREATE DATA SET OF JUST HEADS OF PRIMARY FAMILIES;
DATA prim_heads;
  SET cps1964_new;
  IF relhd=1;
  prim_head_id=pers_id;
  KEEP hhid prim_head_id;
RUN;
* CREATE DATA SET OF JUST HEADS OF UNRELATED SUBFAMILIES;
DATA ursub_heads;
  SET cps1964_new;
  IF famrel=0 AND famtyp=3;
  ursub_head_id=pers_id;
  KEEP hhid ursub_head_id;
RUN;

* CREATE DATA SET OF JUST HEADS OF RELATED SUBFAMILIES;
DATA relsub_heads;
  SET cps1964_new;
  IF famrel=0 AND famtyp=2;
  relsub_head_id=pers_id;
  KEEP hhid relsub_head_id;
RUN;

DATA cps1964_new;
  MERGE cps1964_new(IN=in1) prim_heads ursub_heads relsub_heads;
  BY hhid;
  IF in1;

  IF famtyp IN (1,2) THEN famid=prim_head_id;
    ELSE IF famtyp=3 THEN famid=ursub_head_id;
	ELSE IF famtyp IN (4,5) THEN famid=pers_id;
RUN;
PROC SORT DATA=cps1964_new;
   BY famid;
RUN;
*Create a variable for individuals 18 and above in family & # 14 and older;
PROC MEANS N noprint data=cps1964_new;
  BY famid;
  WHERE age GE 18;
  OUTPUT OUT=family18up N=fam18up;
RUN;
PROC MEANS N noprint data=cps1964_new;
  BY famid;
  WHERE age GE 14;
  OUTPUT OUT=family14up N=fam14up;
RUN;

DATA cps1964_new;
  MERGE cps1964_new(IN=in1) family18up(KEEP=famid fam18up) family14up(KEEP=famid fam14up);
  BY famid;
  IF in1;

  IF fnumper LE 6 THEN fpersons_final=fnumper;
     ELSE IF fnumper GE 7 AND fam18 LE 6 THEN fpersons_final=fam18up+fam18;
	*At this point the only individuals without familysize variables are those that are at the cap 
	for both fnumper (family size) and fam18(family members under 18 (related)) - For these individuals, 
	882, they are all either in a primary family or a related subfamily the following routine takes 
	advantage of this.  It is necessary that no secondary families hit this constraint of family size 
	and family members under 18 which they do not;	 
     ELSE IF fnumper GE 7 AND fam18 GE 7 THEN fpersons_final=numper-hnrlct;

  *DEFINE # UNDER 14 SO CAN ADJUST WEIGHTS.  WE ASSUME THAT THE KIDS UNDER 14 HAVE THE SAME 
   INDIVIDUAL WGT AS THE HEAD, SO ADJUST UP THE WEIGHT OF THE HEAD BY # OF KIDS UNDER 14.
   NOTE, 4 OBS HAVE FAMILY DIFFERENCE LESS THAN ZERO;
  familydifference=fpersons_final-fam14up;

* IF NO RELATED SUBFAMILY PRESENT, THEN GIVE WGT OF PRIMARY HD.  IF RELATED SUBFAMILY PRESENT, GIVE
  WGT OF RELATED SUBFAMILY HEAD;
  IF relhd=1 AND relsub_head_id=. AND familydifference GT 0 THEN pweight=(1+familydifference)*wgt/100;
    ELSE IF famrel=0 AND famtyp=2 AND familydifference GT 0 THEN pweight=(1+familydifference)*wgt/100;
    ELSE IF famrel=0 AND famtyp=3 AND familydifference GT 0 THEN pweight=(1+familydifference)*wgt/100;
	ELSE pweight=wgt/100;

  RENAME hdsex=sex_head;
  RENAME hdager=age_head_code;
  RENAME fam18=tot_kids;
  RENAME income=ptotinc;
  RENAME povcut=official_povcut;
  RENAME rnowrk=rsnnotw;
  RENAME wkslyr=wkswrk;
    

* UNRELATED SECONDARY INDIVIDUALS ARE NOT COUNTED IN OFFICIAL POVERTY IN LATER YEARS.  THERE
  ARE 5 OBS IN THIS SURVEY.;

IF famtyp=5 AND age LE 14 THEN DELETE;

ref_year=1963;

RUN;


*Total population;
proc means sum data=cps1964_new;
var pweight;
run;

*Just Families;
proc means sum data=cps1964_new;
var pweight;
where famtyp IN(1 2 3);
run;

*Unrelated Individuals;
proc means sum data=cps1964_new;
var pweight;
where famtyp IN(4 5);
run;

*Measures of Poverty;
*Add poverty cut off lines;
data poverty1964;
set cps1964_new;
*Use CPI-U to adjust 1964 Poverty Thresholds; 
*Male non-farm; 
if farm=2 then do;
if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1650*0.987096774;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1482*0.987096774;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=2063*0.987096774;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2311*0.987096774;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1852*0.987096774;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2311*0.987096774;
else if  sex_head=0 and fpersons_final=3 and tot_kids=0 then povcut=2402*0.987096774;
else if  sex_head=0 and fpersons_final=3 and tot_kids=1 then povcut=2480*0.987096774;
else if  sex_head=0 and fpersons_final=3 and tot_kids=2 then povcut=2621*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=0 then povcut=3167*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=1 then povcut=3214*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=2 then povcut=3104*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=3 then povcut=3260*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=0 then povcut=3822*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=1 then povcut=3869*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=2 then povcut=3744*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=3 then povcut=3650*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=4 then povcut=3728*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=0 then povcut=4384*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=1 then povcut=4399*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=2 then povcut=4306*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=3 then povcut=4212*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=4 then povcut=4087*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=5 then povcut=4150*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=0 then povcut=5522*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=1 then povcut=5569*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=2 then povcut=5460*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=4 then povcut=5242*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=5 then povcut=5054*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids GE 6 then povcut=5008*0.987096774;
end;

*Female non-farm;
if farm=2 then do;
if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1526*0.987096774;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1464*0.987096774;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1907*0.987096774;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=2081*0.987096774;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1830*0.987096774;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=2081*0.987096774;
else if  sex_head=1 and fpersons_final=3 and tot_kids=0 then povcut=2324*0.987096774;
else if  sex_head=1 and fpersons_final=3 and tot_kids=1 then povcut=2215*0.987096774;
else if  sex_head=1 and fpersons_final=3 and tot_kids=2 then povcut=2449*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=0 then povcut=3042*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=1 then povcut=3151*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=2 then povcut=3136*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=3 then povcut=3104*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=0 then povcut=3650*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=1 then povcut=3760*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=2 then povcut=3744*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=3 then povcut=3713*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=4 then povcut=3588*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=0 then povcut=4259*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=1 then povcut=4337*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=2 then povcut=4306*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=3 then povcut=4274*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=4 then povcut=4134*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=5 then povcut=4009*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=0 then povcut=5350*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=1 then povcut=5429*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=2 then povcut=5413*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=3 then povcut=5366*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=4 then povcut=5226*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=5 then povcut=5117*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=4867*0.987096774;
end;

*Male farm;
if farm=1 then do;
if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1155*0.987096774;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1037*0.987096774;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1444*0.987096774;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1618*0.987096774;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1296*0.987096774;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1618*0.987096774;
else if  sex_head=0 and fpersons_final=3 and tot_kids=0 then povcut=1681*0.987096774;
else if  sex_head=0 and fpersons_final=3 and tot_kids=1 then povcut=1736*0.987096774;
else if  sex_head=0 and fpersons_final=3 and tot_kids=2 then povcut=1835*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=0 then povcut=2217*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=1 then povcut=2250*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=2 then povcut=2173*0.987096774;
else if  sex_head=0 and fpersons_final=4 and tot_kids=3 then povcut=2282*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=0 then povcut=2675*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=1 then povcut=2708*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=2 then povcut=2621*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=3 then povcut=2555*0.987096774;
else if  sex_head=0 and fpersons_final=5 and tot_kids=4 then povcut=2610*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=0 then povcut=3069*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=1 then povcut=3079*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=2 then povcut=3014*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=3 then povcut=2948*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=4 then povcut=2861*0.987096774;
else if  sex_head=0 and fpersons_final=6 and tot_kids=5 then povcut=2905*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=0 then povcut=3865*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=1 then povcut=3898*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=2 then povcut=3822*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=4 then povcut=3669*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=5 then povcut=3538*0.987096774;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3506*0.987096774;
end;

*Female farm;
if farm=1 then do;
if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut=1068*0.987096774;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut=1025*0.987096774;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut=1335*0.987096774;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut=1457*0.987096774;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut=1281*0.987096774;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut=1457*0.987096774;
else if  sex_head=1 and fpersons_final=3 and tot_kids=0 then povcut=1627*0.987096774;
else if  sex_head=1 and fpersons_final=3 and tot_kids=1 then povcut=1551*0.987096774;
else if  sex_head=1 and fpersons_final=3 and tot_kids=2 then povcut=1714*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=0 then povcut=2129*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=1 then povcut=2206*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=2 then povcut=2195*0.987096774;
else if  sex_head=1 and fpersons_final=4 and tot_kids=3 then povcut=2173*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=0 then povcut=2555*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=1 then povcut=2632*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=2 then povcut=2621*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=3 then povcut=2599*0.987096774;
else if  sex_head=1 and fpersons_final=5 and tot_kids=4 then povcut=2512*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=0 then povcut=2981*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=1 then povcut=3036*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=2 then povcut=3014*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=3 then povcut=2992*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=4 then povcut=2894*0.987096774;
else if  sex_head=1 and fpersons_final=6 and tot_kids=5 then povcut=2806*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=0 then povcut=3745*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=1 then povcut=3800*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=2 then povcut=3789*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=3 then povcut=3756*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=4 then povcut=3658*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=5 then povcut=3582*0.987096774;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut=3407*0.987096774;
end;


*1980 Poverty Threshold deflated by CPI-U;
if  age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut1=4284*0.371359223;
else if  age_head_code IN(6 7) and fpersons_final=1 then povcut1=3950*0.371359223;
else if  age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut1=5514*0.371359223;
else if  age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut1=5676*0.371359223;
else if  age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut1=4978*0.371359223;
else if  age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut1=5655*0.371359223;
else if  fpersons_final=3 and tot_kids=0 then povcut1=6442*0.371359223;
else if  fpersons_final=3 and tot_kids=1 then povcut1=6628*0.371359223;
else if  fpersons_final=3 and tot_kids=2 then povcut1=6635*0.371359223;
else if  fpersons_final=4 and tot_kids=0 then povcut1=8494*0.371359223;
else if  fpersons_final=4 and tot_kids=1 then povcut1=8633*0.371359223;
else if  fpersons_final=4 and tot_kids=2 then povcut1=8351*0.371359223;
else if  fpersons_final=4 and tot_kids=3 then povcut1=8380*0.371359223;
else if  fpersons_final=5 and tot_kids=0 then povcut1=10243*0.371359223;
else if  fpersons_final=5 and tot_kids=1 then povcut1=10392*0.371359223;
else if  fpersons_final=5 and tot_kids=2 then povcut1=10074*0.371359223;
else if  fpersons_final=5 and tot_kids=3 then povcut1=9828*0.371359223;
else if  fpersons_final=5 and tot_kids=4 then povcut1=9677*0.371359223;
else if  fpersons_final=6 and tot_kids=0 then povcut1=11782*0.371359223;
else if  fpersons_final=6 and tot_kids=1 then povcut1=11828*0.371359223;
else if  fpersons_final=6 and tot_kids=2 then povcut1=11585*0.371359223;
else if  fpersons_final=6 and tot_kids=3 then povcut1=11351*0.371359223;
else if  fpersons_final=6 and tot_kids=4 then povcut1=11004*0.371359223;
else if  fpersons_final=6 and tot_kids=5 then povcut1=10798*0.371359223;
else if  fpersons_final=7 and tot_kids=0 then povcut1=13556*0.371359223;
else if  fpersons_final=7 and tot_kids=1 then povcut1=13641*0.371359223;
else if  fpersons_final=7 and tot_kids=2 then povcut1=13349*0.371359223;
else if  fpersons_final=7 and tot_kids=3 then povcut1=13146*0.371359223;
else if  fpersons_final=7 and tot_kids=4 then povcut1=12767*0.371359223;
else if  fpersons_final=7 and tot_kids=5 then povcut1=12325*0.371359223;
else if  fpersons_final=7 and tot_kids=6 then povcut1=11840*0.371359223;
else if  fpersons_final=8 and tot_kids=0 then povcut1=15162*0.371359223;
else if  fpersons_final=8 and tot_kids=1 then povcut1=15296*0.371359223;
else if  fpersons_final=8 and tot_kids=2 then povcut1=15020*0.371359223;
else if  fpersons_final=8 and tot_kids=3 then povcut1=14779*0.371359223;
else if  fpersons_final=8 and tot_kids=4 then povcut1=14437*0.371359223;
else if  fpersons_final=8 and tot_kids=5 then povcut1=14002*0.371359223;
else if  fpersons_final=8 and tot_kids=6 then povcut1=13550*0.371359223;
else if  fpersons_final=8 and tot_kids=7 then povcut1=13435*0.371359223;
else if  fpersons_final GE 9 and tot_kids=0 then povcut1=18238*0.371359223;
else if  fpersons_final GE 9 and tot_kids=1 then povcut1=18327*0.371359223;
else if  fpersons_final GE 9 and tot_kids=2 then povcut1=18083*0.371359223;
else if  fpersons_final GE 9 and tot_kids=3 then povcut1=17878*0.371359223;
else if  fpersons_final GE 9 and tot_kids=4 then povcut1=17543*0.371359223;
else if  fpersons_final GE 9 and tot_kids=5 then povcut1=17080*0.371359223;
else if  fpersons_final GE 9 and tot_kids=6 then povcut1=16662*0.371359223;
else if  fpersons_final GE 9 and tot_kids=7 then povcut1=16559*0.371359223;
else if  fpersons_final GE 9 and tot_kids GE 8 then povcut1=15921*0.371359223;


*1962 Poverty Thresholds rescaled using the CPI-U for 1963;
*Male non-farm; 
if farm=2 then do;
if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut2=1614*1.013245033;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=1 then povcut2=1450*1.013245033;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut2=2018*1.013245033;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut2=2261*1.013245033;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut2=1812*1.013245033;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut2=2261*1.013245033;
else if  sex_head=0 and fpersons_final=3 and tot_kids=0 then povcut2=2350*1.013245033;
else if  sex_head=0 and fpersons_final=3 and tot_kids=1 then povcut2=2426*1.013245033;
else if  sex_head=0 and fpersons_final=3 and tot_kids=2 then povcut2=2564*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=0 then povcut2=3098*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=1 then povcut2=3144*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=2 then povcut2=3036*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=3 then povcut2=3189*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=0 then povcut2=3739*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=1 then povcut2=3785*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=2 then povcut2=3663*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=3 then povcut2=3571*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=4 then povcut2=3647*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=0 then povcut2=4289*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=1 then povcut2=4303*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=2 then povcut2=4212*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=3 then povcut2=4120*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=4 then povcut2=3998*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=5 then povcut2=4060*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=0 then povcut2=5402*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=1 then povcut2=5448*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=2 then povcut2=5341*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=3 then povcut2=5249*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=4 then povcut2=5128*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=5 then povcut2=4944*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids GE 6 then povcut2=4899*1.013245033;
end;

*Female non-farm;
if farm=2 then do;
if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut2=1493*1.013245033;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut2=1432*1.013245033;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut2=1866*1.013245033;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut2=2036*1.013245033;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut2=1790*1.013245033;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut2=2036*1.013245033;
else if  sex_head=1 and fpersons_final=3 and tot_kids=0 then povcut2=2273*1.013245033;
else if  sex_head=1 and fpersons_final=3 and tot_kids=1 then povcut2=2167*1.013245033;
else if  sex_head=1 and fpersons_final=3 and tot_kids=2 then povcut2=2396*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=0 then povcut2=2976*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=1 then povcut2=3082*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=2 then povcut2=3068*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=3 then povcut2=3036*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=0 then povcut2=3571*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=1 then povcut2=3678*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=2 then povcut2=3663*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=3 then povcut2=3632*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=4 then povcut2=3510*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=0 then povcut2=4166*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=1 then povcut2=4243*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=2 then povcut2=4212*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=3 then povcut2=4181*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=4 then povcut2=4044*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=5 then povcut2=3922*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=0 then povcut2=5234*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=1 then povcut2=5311*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=2 then povcut2=5295*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=3 then povcut2=5249*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=4 then povcut2=5112*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=5 then povcut2=5006*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut2=4761*1.013245033;
end;

*Male farm;
if farm=1 then do;
if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut2=1130*1.013245033;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=1 then povcut2=1014*1.013245033;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut2=1413*1.013245033;
else if  sex_head=0 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut2=1583*1.013245033;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut2=1268*1.013245033;
else if  sex_head=0 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut2=1583*1.013245033;
else if  sex_head=0 and fpersons_final=3 and tot_kids=0 then povcut2=1644*1.013245033;
else if  sex_head=0 and fpersons_final=3 and tot_kids=1 then povcut2=1698*1.013245033;
else if  sex_head=0 and fpersons_final=3 and tot_kids=2 then povcut2=1795*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=0 then povcut2=2169*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=1 then povcut2=2201*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=2 then povcut2=2126*1.013245033;
else if  sex_head=0 and fpersons_final=4 and tot_kids=3 then povcut2=2232*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=0 then povcut2=2617*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=1 then povcut2=2649*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=2 then povcut2=2564*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=3 then povcut2=2499*1.013245033;
else if  sex_head=0 and fpersons_final=5 and tot_kids=4 then povcut2=2553*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=0 then povcut2=3002*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=1 then povcut2=3012*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=2 then povcut2=2948*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=3 then povcut2=2884*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=4 then povcut2=2799*1.013245033;
else if  sex_head=0 and fpersons_final=6 and tot_kids=5 then povcut2=2842*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=0 then povcut2=3781*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=1 then povcut2=3813*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=2 then povcut2=3739*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=3 then povcut2=3674*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=4 then povcut2=3589*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids=5 then povcut2=3461*1.013245033;
else if  sex_head=0 and fpersons_final GE 7 and tot_kids GE 6 then povcut2=3430*1.013245033;
end;

*Female farm;
if farm=1 then do;
if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=1 then povcut2=1045*1.013245033;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=1 then povcut2=1003*1.013245033;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=0 then povcut2=1306*1.013245033;
else if  sex_head=1 and age_head_code IN(0 1 2 3 4 5) and fpersons_final=2 and tot_kids=1 then povcut2=1425*1.013245033;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=0 then povcut2=1253*1.013245033;
else if  sex_head=1 and age_head_code IN(6 7) and fpersons_final=2 and tot_kids=1 then povcut2=1425*1.013245033;
else if  sex_head=1 and fpersons_final=3 and tot_kids=0 then povcut2=1592*1.013245033;
else if  sex_head=1 and fpersons_final=3 and tot_kids=1 then povcut2=1517*1.013245033;
else if  sex_head=1 and fpersons_final=3 and tot_kids=2 then povcut2=1677*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=0 then povcut2=2083*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=1 then povcut2=2158*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=2 then povcut2=2147*1.013245033;
else if  sex_head=1 and fpersons_final=4 and tot_kids=3 then povcut2=2126*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=0 then povcut2=2499*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=1 then povcut2=2575*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=2 then povcut2=2564*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=3 then povcut2=2542*1.013245033;
else if  sex_head=1 and fpersons_final=5 and tot_kids=4 then povcut2=2457*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=0 then povcut2=2916*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=1 then povcut2=2970*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=2 then povcut2=2948*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=3 then povcut2=2927*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=4 then povcut2=2831*1.013245033;
else if  sex_head=1 and fpersons_final=6 and tot_kids=5 then povcut2=2745*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=0 then povcut2=3664*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=1 then povcut2=3717*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=2 then povcut2=3707*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=3 then povcut2=3674*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=4 then povcut2=3578*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids=5 then povcut2=3504*1.013245033;
else if  sex_head=1 and fpersons_final GE 7 and tot_kids GE 6 then povcut2=3333*1.013245033;
end;


*Create an indicator for whether above or below poverty;
if faminc-povcut>0 then poverty=0;
else if faminc-povcut LE 0 then poverty=1;
if faminc-povcut1>0 then poverty1=0;
else if faminc-povcut1 LE 0 then poverty1=1;
if faminc-povcut2>0 then poverty2=0;
else if faminc-povcut2 LE 0 then poverty2=1;
if faminc-official_povcut>0 then poverty3=0;
else if faminc-official_povcut LE 0 then poverty3=1;
if povoeo=1 then poverty4=1;
else poverty4=0;
pov_diff=povcut-official_povcut;

IF incfrm=. THEN incfrm=0;
IF incse=. THEN incse=0;
IF incwag=. THEN incwag=0;
IF incuer=. THEN incuer=0;

IF fmifrm=. THEN fmifrm=0;
IF fmise=. THEN fmise=0;
IF fmiwag=. THEN fmiwag=0;

ptotearn=SUM(OF incfrm incse incwag);
ftotearn_final=SUM(OF fmifrm fmise fmiwag);
run;

PROC MEANS data=poverty1964;
RUN;

*Poverty Rate Total Population;
proc means data=poverty1964;
var poverty poverty1 poverty2 poverty3 poverty4;
weight pweight;
run;

*Poverty Rate Family Population;
proc means data=poverty1964;
var poverty poverty1 poverty2 poverty3 poverty4;
weight pweight;
where famtyp IN(1 2 3);
run;

*Poverty Rate Unrelated Individuals Population;
proc means data=poverty1964;
var poverty poverty1 poverty2 poverty3 poverty4;
weight pweight;
where famtyp IN(4 5);
run;

DATA cpsdata.all1964;
  set poverty1964;
RUN;
